% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/musycModel.R
\name{fitMusycModel}
\alias{fitMusycModel}
\alias{fitMusycModel.formula}
\alias{fitMusycModel.default}
\title{MuSyC Response Surface Fitting}
\usage{
fitMusycModel(
  formula,
  data,
  variant = "standard",
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)

\method{fitMusycModel}{formula}(
  formula,
  data,
  variant = "standard",
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)

\method{fitMusycModel}{default}(
  formula,
  data,
  variant = "standard",
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{variant}{String specifying which variant of the MuSyC model is to be
fit to the data.  If "standard" (the default), all MuSyC parameters except
\code{gamma12} and \code{gamma21} will be fit (these will be fixed at 1).  If
"independent", the four individual dose-response parameters (\code{IDMA}, \code{IDMB},
\code{na}, and \code{nb}) and the four maximal effect parameters (\code{E0}, \code{EfA}, \code{EfB}
and \code{Ef}) will be fit, while the four interaction parameters (\code{alpha12},
\code{alpha21}, \code{gamma12}, and \code{gamma12}) will all be fixed at 1.  If "full", the
full twelve-parameter MuSyC vector will be fit.}

\item{weights}{An optional vector of weights the same length as \code{act}.  If
\code{NULL} (the default), will be set to 1 for all measurements}

\item{direction}{Determines the possible directionality of the BRAID
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effects are all \emph{greater} than or equal to the minimal effect.  If less
than 0, the fitting will require that all maximal effect is \emph{less} than or
equal to the minimal effect.}

\item{lower}{An optional set of lower bounds on the fitted MuSyC response
parameters.  Any values set to NA will be filled with default calculated
bounds. May be length 4 (will be treated as a set of lower bounds on the
minimal and maximal effect parameters only), length 8 (will be treated as
lower bounds on the four individual dose response parameters and the four
minimal and maximla effect parameters), the same length as the space of
parameters being optimized (8 for "independent", 10 for "standard", or 12
for "full"), or length 12.}

\item{upper}{An optional set of lower bounds on the fitted MuSyC response
parameters.  Behaves the same as \code{lower}.}
}
\value{
An object of class \code{braidAltFit} with the following values:
\itemize{
\item \code{concs}: The array of concentrations passed to the functions
\item \code{act}: The vector of measurements associated with the given dose pairs
\item \code{weights}: The vector of weights for the given measurements, set to 1 for
all measurements by default
\item \code{method}: Specifying the alternate surface model being used (in this case
"MuSyC")
\item \code{variant}: A string specifying which MuSyC variant was fit: "independent",
"standard", or "full"
\item \code{coefficients}: A parameter vector of the appropriate length for \code{variant}
specifying the best fit response surface
\item \code{fitted.values}: The predicted response surface value for the given dose
pairs and best-fit response surface
\item \code{residuals}: The difference between the predicted and measured values for
the given dose pairs, always equal to "measured minus predicted"
\item \code{direction}: The direction value passed to the function
\item \code{pbounds}': A 2-by-k array of bounds on the MuSyC parameters used in the
parameter optimization
}
}
\description{
Fits the Multidimensional Synergy of Combinations (MuSyC) model of combined
action to the given data (Wooten \emph{et al.} 2021).
}
\examples{
mfit1 <- fitMusycModel(measure ~ concA + concB, synergisticExample)
coef(mfit1)

mfit2 <- fitMusycModel(measure ~ concA + concB, oppositionalExample,
                       variant = "independent")
coef(mfit2)
}
\references{
Wooten, David J, Christian T Meyer, Alexander LR Lubbock, Vito Quaranta,
and Carlos F Lopez. 2021. “MuSyC Is a Consensus Framework That Unifies
Multi-Drug Synergy Metrics for Combinatorial Drug Discovery.”
\emph{Nature Communications} \strong{12} (1): 4607.
}
