% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim_rand_graph_clust.R
\name{sim.rand.graph.clust}
\alias{sim.rand.graph.clust}
\title{Simulate a random graph with given degree sequence and clustering.}
\usage{
sim.rand.graph.clust(graph, cl = graph$transitivity, max.iters = 100)
}
\arguments{
\item{graph}{The graph from which null graphs are simulated}

\item{cl}{The clustering measure (default: transitivity)}

\item{max.iters}{The maximum number of iterations to perform (default: 100)}
}
\value{
A list with components:
\item{g}{The random graph that was generated}
\item{iters}{The total number of iterations performed}
\item{cl}{The clustering coefficient at each step}
}
\description{
This function will simulate a random graph with a given degree sequence and
clustering coefficient. This function calls \link{choose.edges} to decide
which edges will be re-wired.
}
\seealso{
\code{\link{choose.edges}, \link[igraph]{rewire},
\link[igraph]{transitivity}, \link[igraph]{keeping_degseq}}
}

