% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_dist.R
\name{vertex_spatial_dist}
\alias{vertex_spatial_dist}
\title{Calculate average Euclidean distance for each vertex}
\usage{
vertex_spatial_dist(g)
}
\arguments{
\item{g}{An \code{igraph} graph object}
}
\value{
A named numeric vector of average distance (in \emph{mm})
}
\description{
This function calculates, for each vertex of a graph, the average Euclidean
distance across all of that vertex's connections.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Alexander-Bloch A.F., Vertes P.E., Stidd R. et al. (2013)
  \emph{The anatomical distance of functional connections predicts brain
  network topology in health and schizophrenia}. Cerebral Cortex, 23:127-138.
}

