% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individ_contrib.R
\name{loo}
\alias{loo}
\title{"Leave-one-out" approach to estimate individual network contribution}
\usage{
loo(resids, corrs, level = c("global", "regional"))
}
\arguments{
\item{resids}{Data table of model residuals}

\item{corrs}{List of lists of correlation matrices (as output by}

\item{level}{Character string; the level at which you want to calculate
contributions (either \emph{global} or \emph{regional})
  \code{\link{corr.matrix}}). The length should equal the number of groups.}
}
\value{
A \code{data.table} with columns for
  \item{Study.ID}{Subject identifier}
  \item{Group}{Group membership}
  \item{IC}{The value of the individual contribution}
}
\description{
Calculates the individual contribution to group network data for each subject
in each group using a "leave-one-out" approach. The residuals of a single
subject are excluded, and a correlation matrix is created. This is compared
to the original correlation matrix using the Mantel test.
}
\examples{
\dontrun{
IC <- loo(resids.all, corrs)
RC <- loo(resids.all, corrs, level='regional')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Saggar M., Hosseini S.M.H., Buno J.L., Quintin E., Raman M.M.,
  Kesler S.R., Reiss A.L. (2015) \emph{Estimating individual contributions
  from group-based structural correlations networks}. NeuroImage, 120:274-284.
  doi:10.1016/j.neuroimage.2015.07.006
}

