% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_group_auc.R
\name{permute.group.auc}
\alias{permute.group.auc}
\title{Permutation test for group difference of graph measures}
\usage{
permute.group.auc(permSet, densities, resids, level = c("graph", "vertex",
  "lobe", "other"), atlas, measure = c("btwn.cent", "degree", "E.nodal",
  "knn", "transitivity", "vulnerability"), .function = NULL)
}
\arguments{
\item{permSet}{A matrix of the set of permutations to loop through; the
number of rows equals the desired number of permutations and the number of
columns equals the total number of subjects across groups}

\item{densities}{Numeric; vector of graph densities}

\item{resids}{A data table of the residuals (from \code{\link{get.resid}})}

\item{level}{A character string for the attribute level to calculate
differences; either 'graph', 'vertex', 'lobe', or 'other'}

\item{atlas}{Character string of the atlas name}

\item{measure}{A character string, either 'btwn.cent', 'degree', 'E.nodal',
'knn', or 'transitivity', 'vulnerability' (specific to the vertex \emph{level})}

\item{.function}{A custom function you can pass (if \emph{level} is 'other')}
}
\value{
A data table with values for group differences in modularity, global
efficiency, clustering, average path length, and assortativity (etc.)
}
\description{
This function draws permutations from linear model residuals to determine the
significance of between-group differences of a global or vertex-wise graph
measure. This function is intended for cortical thickness networks (in which
there is only one graph per group), but can be extended to other types of
data.
}
\details{
The \emph{graph} "level" will calculate modularity (Louvain algorithm),
clustering coefficient, average path length, degree assortativity, global
efficiency, lobe assortativity, and edge asymmetry.

The \emph{vertex} "level" will calculate a vertex-wise measure. Currently,
you can choose betweenness centrality, degree, nodal efficiency, k-nearest
neighbor degree, transitivity, or vulnerability.

The \emph{lobe} "level" is intended to test for group differences in number
of inter-lobar connections, e.g. from the temporal lobe to the rest of the
brain.

The \emph{other} "level" allows you to pass your own function to do
permutations with. This is useful if you want to calculate something that I
haven't hard-coded (e.g. number of hubs between groups). It must take as its
own arguments: "g1", "g2", and "density".
}
\examples{
\dontrun{
m <- get.resid(all.thick, covars)
myPerms <- shuffleSet(n=nrow(m$resids), nset=1e3)
out <- permute.group(myPerms, densities[N], m$resids, 'graph', atlas='dk')
out <- permute.group(myPerms, densities[N], m$resids, 'vertex')
out <- permute.group(myPerms, densities[N], m$resids, 'other',
  .function=myFun)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[igraph]{centr_betw}, \link{vulnerability},
\link{count_interlobar}, \link{edge_asymmetry}, \link{graph.efficiency}}
}

