% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_intersection_brainGraph}
\alias{make_intersection_brainGraph}
\title{Create the intersection of graphs based on a logical condition}
\usage{
make_intersection_brainGraph(..., subgraph)
}
\arguments{
\item{...}{Graph objects or lists of graph objects}

\item{subgraph}{Character string specifying an equation (logical condition)
for the vertices to subset}
}
\value{
An \code{igraph} graph object
}
\description{
Create the intersection of graphs based on a logical condition
}
\examples{
\dontrun{
res.mtpc <- mtpc(g, covars, ...)
g.mtpc <- make_glm_brainGraph(res.mtpc, atlas)
g.mtpc.int <- make_intersection_brainGraph(g.mtpc,
  subgraph='sig == 1')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
