% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_global.R
\name{Bootstrapping}
\alias{Bootstrapping}
\alias{brainGraph_boot}
\alias{summary.brainGraph_boot}
\alias{plot.brainGraph_boot}
\title{Bootstrapping for global graph measures}
\usage{
brainGraph_boot(densities, resids, R = 1000, measure = c("mod",
  "E.global", "Cp", "Lp", "assortativity", "strength", "mod.wt",
  "E.global.wt"), conf = 0.95, .progress = TRUE, xfm.type = c("1/w",
  "-log(w)", "1-w"))

\method{summary}{brainGraph_boot}(object, ...)

\method{plot}{brainGraph_boot}(x, ..., alpha = 0.4)
}
\arguments{
\item{densities}{Numeric vector of graph densities to loop through}

\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{R}{Integer; the number of bootstrap replicates (default: \code{1e3})}

\item{measure}{Character string of the measure to test (default: \code{mod})}

\item{conf}{Numeric; the confidence level for calculating confidence
intervals (default: 0.95)}

\item{.progress}{Logical indicating whether or not to show a progress bar
(default: \code{TRUE})}

\item{xfm.type}{Character string specifying how to transform the weights
(default: \code{1/w})}

\item{object}{A \code{brainGraph_boot} object (from
\code{\link{brainGraph_boot}})}

\item{...}{Unused}

\item{x}{A \code{\link{brainGraph_boot}} object}

\item{alpha}{A numeric indicating the opacity for
\code{\link[ggplot2]{geom_ribbon}}}
}
\value{
\code{brainGraph_boot} -- an object of class \code{brainGraph_boot}
  containing some input variables, in addition to a list of
  \code{\link[boot]{boot}} objects (one for each group).

\code{plot} -- \emph{list} with the following elements:
  \item{se}{A ggplot object with ribbon representing standard error}
  \item{ci}{A ggplot object with ribbon representing confidence intervals}
}
\description{
Perform bootstrapping to obtain groupwise standard error estimates of a
global graph measure (e.g. \emph{modularity}).

The \code{plot} method returns two \code{ggplot} objects: one with shaded
regions based on the standard error, and the other based on confidence
intervals (calculated using the normal approximation.
}
\details{
The confidence intervals are calculated using the \emph{normal approximation}
at the \eqn{100 \times conf}\% level (by default, 95\%).

For getting estimates of \emph{weighted global efficiency}, a method for
transforming edge weights must be provided. The default is to invert them.
See \code{\link{xfm.weights}}.
}
\examples{
\dontrun{
boot.E.global <- brainGraph_boot(densities, resids.all, 1e3, 'E.global')
}
}
\seealso{
\code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}

Other Group analysis functions: \code{\link{GLM}},
  \code{\link{IndividualContributions}},
  \code{\link{MediationAnalysis}}, \code{\link{NBS}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}

Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{Residuals}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{import_scn}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Group analysis functions}
\concept{Structural covariance network functions}
