% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{partition}
\alias{partition}
\title{Partition a design matrix into columns of interest and nuisance}
\usage{
partition(M, con.mat, part.method = c("beckmann", "guttman"))
}
\arguments{
\item{M}{Numeric matrix; the full design matrix}

\item{con.mat}{Numeric matrix; the contrast matrix}

\item{part.method}{Character string; the method of partitioning (default:
\code{beckmann})}
}
\value{
A list containing:
  \item{X}{Numeric matrix for the covariates of interest}
  \item{Z}{Numeric matrix for the nuisance covariates}
  \item{eCm}{The \emph{effective contrast}, equivalent to the original, for
    the partitioned model \code{[X, Z]} and considering all covariates}
  \item{eCx}{Same as \code{eCx}, but considering only \code{X}}
}
\description{
Consider the matrix formulation of the \emph{general linear model}:
\deqn{\mathbf{Y} = \mathbf{M} \psi + \in}
where \eqn{Y} is the vector of outcomes, \eqn{M} is the full design matrix
(including nuisance covariates), \eqn{\psi} is the vector of parameter
estimates, and \eqn{\in} is the vector of error terms. In a permutation
framework, algorithms are applied differently depending on the
presence/absence of nuisance covariates; thus the model is separated
depending on the contrast of interest:
\deqn{\mathbf{Y} = \mathbf{X}\beta + \mathbf{Z}\gamma + \in}
where \eqn{\mathbf{X}} contains covariates of interest, \eqn{\mathbf{Z}}
contains nuisance covariates, and \eqn{\beta} and \eqn{\gamma} are the
associated parameter estimates.
}
\references{
Guttman I. Linear Models: An Introduction. Wiley, New York, 1982.

Smith SM, Jenkinson M, Beckmann C, Miller K, Woolrich M (2007).
  \emph{Meaningful design and contrast estimability in fMRI.} NeuroImage,
  34(1):127-36.
}
\keyword{internal}
