% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piece-count.R
\name{build_pieces}
\alias{build_pieces}
\title{Display bricks required to build model or mosaic}
\usage{
build_pieces(brick_obj)
}
\arguments{
\item{brick_obj}{brickr mosaic or 3D model object.}
}
\value{
Plot object of required bricks by color and size.
}
\description{
Create a chart of brick colors and sizes used in a brick mosaic or model.
}
\examples{
# Import a jpeg or png
 demo_file <- system.file("extdata", "demo_img.jpg", 
                          package = "brickr", mustWork = TRUE)
 demo_image <- jpeg::readJPEG(demo_file)
#Create a mosaic oject 
 \donttest{
 mosaic <- demo_image \%>\% 
   image_to_mosaic(img_size = 24)
 }
 
 #Rather than drawing the mosaic, use build_pieces_table() to draw piece chart
 \donttest{
  mosaic \%>\% 
   build_pieces()
 }
}
\seealso{
Other Resources: 
\code{\link{build_colors}()},
\code{\link{build_instructions}()},
\code{\link{build_pieces_table}()}
}
\concept{Resources}
