% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_probabilities.R
\name{brm_marginal_probabilities}
\alias{brm_marginal_probabilities}
\title{Marginal probabilities on the treatment effect for an MMRM.}
\usage{
brm_marginal_probabilities(draws, direction = "greater", threshold = 0)
}
\arguments{
\item{draws}{Posterior draws of the marginal posterior
obtained from \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{direction}{Character vector of the same length as \code{threshold}.
\code{"greater"} to compute the marginal posterior probability that the
treatment effect is greater than the threshold,
\code{"less"} to compute the marginal posterior probability that the
treatment effect is less than the threshold.
Each element \code{direction[i]} corresponds to \code{threshold[i]}
for all \code{i} from 1 to \code{length(direction)}.}

\item{threshold}{Numeric vector of the same length as \code{direction},
treatment effect threshold for computing posterior probabilities.
Each element \code{direction[i]} corresponds to \code{threshold[i]} for
all \code{i} from 1 to \code{length(direction)}.}
}
\value{
A tibble of probabilities of the form
\verb{Prob(treatment effect > threshold | data)} and/or
\verb{Prob(treatment effect < threshold | data)}. It has one row per
probability and the following columns:
* \code{group}: treatment group.
* \code{time}: discrete time point,
* \code{direction}: direction of the comparison in the marginal probability:
\code{"greater"} for \code{>}, \code{"less"} for \code{<}
* \code{threshold}: treatment effect threshold in the probability statement.
* \code{value}: numeric value of the estimate of the probability.
}
\description{
Marginal probabilities on the treatment effect for an MMRM.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
draws <- brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
brm_marginal_probabilities(draws, direction = "greater", threshold = 0)
}
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_draws}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
