% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate_outline.R
\name{brm_simulate_outline}
\alias{brm_simulate_outline}
\title{Start a simulated dataset}
\usage{
brm_simulate_outline(
  n_group = 2L,
  n_subgroup = NULL,
  n_patient = 100L,
  n_time = 4L,
  rate_dropout = 0.1,
  rate_lapse = 0.05
)
}
\arguments{
\item{n_group}{Positive integer of length 1, number of treatment groups.}

\item{n_subgroup}{Positive integer of length 1, number of subgroup levels.
Set to \code{NULL} to omit the subgroup entirely.}

\item{n_patient}{Positive integer of length 1.
If \code{n_subgroup} is \code{NULL}, then \code{n_patient} is the number of patients
per treatment group. Otherwise, \code{n_patient} is the number of patients
per treatment group \emph{per subgroup}. In both cases, the total number of
patients in the whole simulated dataset is usually much greater than the
\code{n_patients} argument of \code{\link[=brm_simulate_outline]{brm_simulate_outline()}}.}

\item{n_time}{Positive integer of length 1, number of discrete
time points (e.g. scheduled study visits) per patient.}

\item{rate_dropout}{Numeric of length 1 between 0 and 1,
post-baseline dropout rate.
A dropout is an intercurrent event when data
collection for a patient stops permanently,
causing the outcomes for that patient to be missing during and after
the dropout occurred. The first time point is assumed to be baseline,
so dropout is there. Dropouts are equally likely to occur at each of
the post-baseline time points.}

\item{rate_lapse}{Numeric of length 1, expected proportion of post-baseline
outcomes that are missing. Missing outcomes of this type are independent
and uniformly distributed across the data.}
}
\value{
A classed data frame from \code{\link[=brm_data]{brm_data()}}.
The data frame has one row per
patient per time point and the following columns:
\itemize{
\item \code{group}: integer index of the treatment group.
\item \code{patient}: integer index of the patient.
\item \code{time}: integer index of the discrete time point.
}
}
\description{
Begin creating a simulated dataset.
}
\examples{
brm_simulate_outline()
}
\seealso{
Other simulation: 
\code{\link{brm_simulate_categorical}()},
\code{\link{brm_simulate_continuous}()},
\code{\link{brm_simulate_prior}()},
\code{\link{brm_simulate_simple}()}
}
\concept{simulation}
