% Generated by roxygen2 (4.0.0): do not edit by hand
\name{brocolors}
\alias{brocolors}
\title{Vectors of colors for figures}
\usage{
brocolors(set = c("general", "bg", "bgpng", "CC", "f2", "sex", "main",
  "crayons"))
}
\arguments{
\item{set}{Character string indicating a set of colors.}
}
\value{
Vector of character strings representing the chosen set of colors, in RGB.
}
\description{
Creates different vectors of related colors that may be useful for figures.
}
\examples{
plot(0, 0, type="n", xlab="", ylab="", xlim=c(0, 9), ylim=c(7.5, 0), yaxs="i",
     xaxt="n", yaxt="n", mar=c(0.6, 5.1, 0.6, 0.6), xaxs="i")
axis(side=2, at=1:7, c("general", "bg", "bgpng", "CC", "f2", "sex", "main"), las=1)

gen <- brocolors("general")
points(seq(along=gen), rep(1,length(gen)), pch=21, bg=gen, cex=4)
text(seq(along=gen), rep(c(0.55, 0.7), length(gen))[seq(along=gen)], names(gen))

points(1, 2, pch=21, bg=brocolors("bg"), cex=4)
points(1, 3, pch=21, bg=brocolors("bgpng"), cex=4)

CC <- brocolors("CC")
points(seq(along=CC), rep(4,length(CC)), pch=21, bg=CC, cex=4)
text(seq(along=CC), rep(3+c(0.55, 0.7), length(CC))[seq(along=CC)], names(CC))

f2 <- brocolors("f2")
points(seq(along=f2), rep(5,length(f2)), pch=21, bg=f2, cex=4)
text(seq(along=f2), rep(4.7, length(f2)), names(f2))

sex <- brocolors("sex")
points(seq(along=sex), rep(6,length(sex)), pch=21, bg=sex, cex=4)
text(seq(along=sex), rep(5.7, length(sex)), names(sex))

points(1, 7, pch=21, bg=brocolors("main"), cex=4)
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{plot_crayons}}
}
\keyword{utilities}

