% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strwidth2lines.R
\name{strwidth2lines}
\alias{strwidth2lines}
\title{Calculate width of a character string in number of lines}
\usage{
strwidth2lines(s, ...)
}
\arguments{
\item{s}{A character or expression vector whose length is to be calculated}

\item{...}{additional information used by \code{strwidth}, such as
\code{cex}}
}
\value{
Maximum string width in units of margin lines
}
\description{
Convert \code{stringwidth} units to number of (margin) lines
}
\examples{
p <- par(TRUE)
string <- sapply(sample(1:20,15,replace=TRUE),
         function(a) paste(LETTERS[1:a], collapse=""))
nlines <- strwidth2lines(string)
mar <- par("mar")
par(mar=c(mar[1],nlines+0.1,mar[3:4]))
  plot(1:length(string),1:length(string),yaxt="n", ylab="")
  axis(side=2, at=seq_along(string), lab=string, las=1)
par(p)
nlines <- strwidth2lines(string,cex=1.5)
par(mar=c(mar[1:3],nlines+0.1))
  plot(1:length(string),1:length(string),ylab="")
  mgp <- par("mgp")
  axis(side = 4, at=seq_along(string),
    labels = string ,las=1, hadj=1,
       mgp=c(mgp[1],nlines,mgp[3]),cex.axis=1.5)
par(p)
}
\author{
Aimee Teo Broman
}

