% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holmans_triangle.R
\name{triplot}
\alias{triplot}
\title{Plot Holmans triangle}
\usage{
triplot(
  labels = c("(1,0,0)", "(0,1,0)", "(0,0,1)"),
  col = "black",
  lwd = 2,
  bgcolor = "gray90",
  gridlines = 0,
  grid_col = "white",
  grid_lty = 1,
  grid_lwd = 1,
  ...
)
}
\arguments{
\item{labels}{Labels for the three corners (lower-right, top, lower-left).}

\item{col}{Color of edges of triangle}

\item{lwd}{Line width for edges of triangle}

\item{bgcolor}{Background color for triangle}

\item{gridlines}{Number of grid lines (if 0, no grid lines will be plotted)}

\item{grid_col}{Color of grid lines}

\item{grid_lty}{Line type of grid lines}

\item{grid_lwd}{Line width of grid lines}

\item{...}{Passed to \code{\link[base:plot]{base::plot()}}.}
}
\value{
The (x,y) coordinates of the points plotted, if any.
}
\description{
Plot Holmans triangle (an equilateral triangle used to depict
trinomial distributions).
}
\details{
Plot of an equilateral triangle, in order to depict trinomial
distributions.  A trinomial distribution (that is, a trio of
non-negative numbers that add to 1) is equated to a point in the
triangle through the distances to the three sides.  This makes use of
the fact that for any point in an equilateral triangle, the sum of the
distances to the three sides is constant.
The \code{triplot} function creates an empty triangle for use with the
related functions \code{\link[=tripoints]{tripoints()}}, \code{\link[=trilines]{trilines()}},
\code{\link[=triarrow]{triarrow()}}.
}
\examples{
triplot()
x <- cbind(c(0.9, 0.05, 0.05), c(0.8, 0.1, 0.1), c(0.1, 0.9, 0), c(0, 0.9, 0.1))
tripoints(x, lwd=2, col=c("black","blue","red","green"), pch=16)
trilines(x, lwd=2, col="orange")
y <- cbind(c(0.05, 0.05, 0.9), c(0.25, 0.25, 0.5))
triarrow(y, col="blue", lwd=2, len=0.1)

}
\seealso{
\code{\link[=tripoints]{tripoints()}}, \code{\link[=trilines]{trilines()}},
\code{\link[=triarrow]{triarrow()}}, \code{\link[=tritext]{tritext()}}
}
\keyword{hplot}
