% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_terms_levels.R
\name{model_list_terms_levels}
\alias{model_list_terms_levels}
\alias{model_list_terms_levels.default}
\title{List levels of categorical terms}
\usage{
model_list_terms_levels(
  model,
  label_pattern = "{level}",
  variable_labels = NULL
)

\method{model_list_terms_levels}{default}(
  model,
  label_pattern = "{level}",
  variable_labels = NULL
)
}
\arguments{
\item{model}{a model object}

\item{label_pattern}{a \link[glue:glue]{glue pattern} for term labels (see examples)}

\item{variable_labels}{an optional named list or named vector of
custom variable labels passed to \code{\link[=model_list_variables]{model_list_variables()}}}
}
\value{
A tibble with ten columns:
\itemize{
\item \code{variable}: variable
\item \code{contrasts_type}: type of contrasts ("sum" or "treatment")
\item \code{term}: term name
\item \code{level}: term level
\item \code{reference}: logical indicating which term is the reference level
\item \code{reference_level}: level of the reference term
\item \code{var_label}: variable label obtained with \code{\link[=model_list_variables]{model_list_variables()}}
\item \code{var_nlevels}: number of levels in this variable
\item \code{dichotomous}: logical indicating if the variable is dichotomous
\item \code{label}: term label (by default equal to term level)
The first nine columns can be used in \code{label_pattern}.
}
}
\description{
Only for categorical variables with treatment,
SAS or sum contrasts.
}
\examples{
glm(
  am ~ mpg + factor(cyl),
  data = mtcars,
  family = binomial,
  contrasts = list(`factor(cyl)` = contr.sum)
) \%>\%
  model_list_terms_levels()

df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))

mod <- df \%>\%
  glm(
    Survived ~ Class + Age + Sex,
    data = ., weights = .$n, family = binomial,
    contrasts = list(Age = contr.sum, Class = "contr.helmert")
  )
mod \%>\% model_list_terms_levels()
mod \%>\% model_list_terms_levels("{level} vs {reference_level}")
mod \%>\% model_list_terms_levels("{variable} [{level} - {reference_level}]")
mod \%>\% model_list_terms_levels(
  "{ifelse(reference, level, paste(level, '-', reference_level))}"
)
}
\seealso{
Other model_helpers: 
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
