% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_xlevels.R
\name{model_get_xlevels}
\alias{model_get_xlevels}
\alias{model_get_xlevels.default}
\alias{model_get_xlevels.lmerMod}
\alias{model_get_xlevels.glmerMod}
\alias{model_get_xlevels.felm}
\alias{model_get_xlevels.brmsfit}
\alias{model_get_xlevels.glmmTMB}
\title{Get xlevels used in the model}
\usage{
model_get_xlevels(model)

\method{model_get_xlevels}{default}(model)

\method{model_get_xlevels}{lmerMod}(model)

\method{model_get_xlevels}{glmerMod}(model)

\method{model_get_xlevels}{felm}(model)

\method{model_get_xlevels}{brmsfit}(model)

\method{model_get_xlevels}{glmmTMB}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
Get xlevels used in the model
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) \%>\%
  model_get_xlevels()
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
