% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy_parameters}
\alias{tidy_parameters}
\title{Tidy a model with parameters package}
\usage{
tidy_parameters(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a model}

\item{conf.int}{logical indicating whether or not to include a confidence
interval in the tidied output}

\item{conf.level}{the confidence level to use for the confidence interval}

\item{...}{additional parameters passed to \code{parameters::model_parameters()}}
}
\description{
Use \code{parameters::model_parameters()} to tidy a model and apply
\code{parameters::standardize_names(style = "broom")} to the output
}
\examples{
\dontshow{if (interactive() && .assert_package("parameters", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lm(Sepal.Length ~ Sepal.Width + Species, data = iris) \%>\%
  tidy_parameters()
\dontshow{\}) # examplesIf}
}
\seealso{
Other custom_tieders: 
\code{\link{tidy_with_broom_or_parameters}()}
}
\concept{custom_tieders}
