% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz-tidiers.R
\name{glance.muhaz}
\alias{glance.muhaz}
\title{Glance at a(n) muhaz object}
\usage{
\method{glance}{muhaz}(x, ...)
}
\arguments{
\item{x}{A \code{muhaz} object returned by \code{\link[muhaz:muhaz]{muhaz::muhaz()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{nobs}{Number of observations used for estimation}
\item{min.time}{The minimum observed event or censoring time}
\item{max.time}{The maximum observed event or censoring time}
\item{min.harzard}{Minimal estimated hazard}
\item{max.hazard}{Maximal estimated hazard}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[muhaz:muhaz]{muhaz::muhaz()}}

Other muhaz tidiers: 
\code{\link{tidy.muhaz}()}
}
\concept{muhaz tidiers}
