% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{GB2Dist}
\alias{GB2Dist}
\alias{dGB2}
\alias{moment_GB2}
\alias{pGB2}
\alias{qGB2}
\alias{rGB2}
\alias{summary_GB2}
\title{Gamma-Beta2 distribution}
\usage{
dGB2(x, a, c, d, tau)

pGB2(q, a, c, d, tau, ...)

qGB2(p, a, c, d, tau)

rGB2(n, a, c, d, tau)

moment_GB2(k, a, c, d, tau)

summary_GB2(a, c, d, tau, output = "list", ...)
}
\arguments{
\item{x,q}{vector of non-negative quantiles}

\item{a,c,d}{non-negative shape parameters}

\item{tau}{non-negative rate parameter}

\item{...}{arguemnts passed to \code{\link[=hypergeo]{genhypergeo}} function}

\item{p}{vector of probabilities}

\item{n}{number of observations to be sampled}

\item{k}{the order of the moment}

\item{output}{type of the \code{summary_GB2} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}
}
\value{
\code{dGB2} gives the density, \code{pGB2} the cumulative function,
\code{rGB2} samples from the distribution, and \code{summary_GB2} gives a summary
of the distribution.
}
\description{
Density and random generation for the  Gamma-Beta2 distribution
with shape parameters \code{a}, \code{c}, \code{d}
and rate parameter \code{tau} (scale of the Beta2 distribution).










}
\details{
This is the mixture distribution obtained by sampling a value \eqn{y}
from the \link[=Beta2Dist]{Beta2 distribution} with shape parameters \eqn{c}, \eqn{d},
and scale \eqn{\tau} and
then sampling a value  from the Gamma distribution with
shape \eqn{a} and rate \eqn{y}.
The pdf involves
the Kummer confluent hypergeometric function of the second kind.
The cdf involves the generalized hypergeometric function. Its current implementation
does not work when \code{a-d} is an integer, and also fails for many other cases.
}
\note{
\code{GB2Dist} is a generic name for the functions documented.
}
\examples{
a <- 2 ; c <- 4 ; d <- 3; tau <- 1.67
sims <- rGB2(1e6, a, c, d, tau)
mean(sims); moment_GB2(1,a,c,d,tau)
mean(sims^2); moment_GB2(2,a,c,d,tau)
summary_GB2(a,c,d,tau)
}

