% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive_prior.R
\name{Prior_x_given_y}
\alias{Prior_x_given_y}
\alias{dprior_x_given_y}
\alias{pprior_x_given_y}
\alias{qprior_x_given_y}
\alias{rprior_x_given_y}
\alias{sprior_x_given_y}
\title{Prior predictive distribution of the count \eqn{x} in the treated group
conditionally to the count \eqn{y} in the treated group}
\usage{
dprior_x_given_y(x, y, a, c, d)

pprior_x_given_y(q, y, a, c, d)

qprior_x_given_y(p, y, a, c, d)

rprior_x_given_y(n, y, a, c, d)

sprior_x_given_y(y, a, c, d, ...)
}
\arguments{
\item{x,q}{vector of non-negative \strong{integer} quantiles}

\item{y}{count (integer) in the control group}

\item{a}{non-negative shape parameter of the Gamma prior distribution on the rate \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{...}{arguments passed to \code{\link{summary_beta_nbinom}}}
}
\value{
\code{dprior_x_given_y} gives the density,
\code{pprior_x_given_y} the distribution function,
\code{qprior_x_given_y} the quantile function,
\code{rprior_x_given_y} samples from the distribution, and
\code{sprior_x_given_y} gives a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the conditional prior predictive distribution of \eqn{x}
given \eqn{y}.










}
\details{
The prior predictive distribution of the count \eqn{x} is the
\code{\link[=BNBDist]{Beta-negative binomial distribution}}
with shape parameters \eqn{a+y}, \eqn{d}, \eqn{c}.
}
\note{
\code{Prior_x_given_y} is a generic name for the functions documented.
}
\examples{
barplot(dprior_x_given_y(0:10, 5, 3, 10, 20))
sprior_x_given_y(5, 3, 10, 20, output="pandoc")
}

