% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{brulee-coefs}
\alias{brulee-coefs}
\alias{coef.brulee_logistic_reg}
\alias{coef.brulee_linear_reg}
\alias{coef.brulee_mlp}
\alias{coef.brulee_multinomial_reg}
\title{Extract Model Coefficients}
\usage{
\method{coef}{brulee_logistic_reg}(object, epoch = NULL, ...)

\method{coef}{brulee_linear_reg}(object, epoch = NULL, ...)

\method{coef}{brulee_mlp}(object, epoch = NULL, ...)

\method{coef}{brulee_multinomial_reg}(object, epoch = NULL, ...)
}
\arguments{
\item{object}{A model fit from \pkg{brulee}.}

\item{epoch}{A single integer for the training iteration. If left \code{NULL},
the estimates from the best model fit (via internal performance metrics).}

\item{...}{Not currently used.}
}
\value{
For logistic/linear regression, a named vector. For neural networks,
a list of arrays.
}
\description{
Extract Model Coefficients
}
\examples{
\donttest{
if (torch::torch_is_installed() & rlang::is_installed(c("recipes", "modeldata"))) {

 data(ames, package = "modeldata")

 ames$Sale_Price <- log10(ames$Sale_Price)

 set.seed(1)
 in_train <- sample(1:nrow(ames), 2000)
 ames_train <- ames[ in_train,]
 ames_test  <- ames[-in_train,]

 # Using recipe
 library(recipes)

 ames_rec <-
  recipe(Sale_Price ~ Longitude + Latitude, data = ames_train) \%>\%
    step_normalize(all_numeric_predictors())

 set.seed(2)
 fit <- brulee_linear_reg(ames_rec, data = ames_train,
                           epochs = 50, batch_size = 32)

 coef(fit)
 coef(fit, epoch = 1)
}
}
}
