% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Table}
\alias{bs4Table}
\title{Create a Boostrap 4 table container}
\usage{
bs4Table(
  ...,
  cardWrap = FALSE,
  headTitles,
  bordered = FALSE,
  striped = FALSE,
  width = 12
)
}
\arguments{
\item{...}{\link{bs4TableItems}.}

\item{cardWrap}{Whether to wrap the table in a card. FALSE by default.}

\item{headTitles}{Table header names. Must have the same length as the number of 
\link{bs4TableItem} in \link{bs4TableItems}. Set "" to have an empty title field.}

\item{bordered}{Whether to display border between elements. FALSE by default.}

\item{striped}{Whether to displayed striped in elements. FALSE by default.}

\item{width}{Table width. 12 by default.}
}
\description{
Build an argon table container
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    navbar = bs4DashNavbar(), 
    sidebar = bs4DashSidebar(),
    body = bs4DashBody(
     bs4Table(
      cardWrap = TRUE,
      bordered = TRUE,
      striped = TRUE,
      headTitles = c(
       "PROJECT",
       "BUDGET",
       "STATUS",
       "USERS",
       "COMPLETION",
       ""
      ),
      bs4TableItems(
       bs4TableItem("bs4 Design System"),
       bs4TableItem(dataCell = TRUE, "$2,500 USD"),
       bs4TableItem(
        dataCell = TRUE, 
        bs4Badge(
         "Pending",
         position = "right",
         status = "danger",
         rounded = TRUE
        )
       ),
       bs4TableItem(
        progressBar(id = "pb1", value = 50, size = "xxs")
       ),
       bs4TableItem(
        dataCell = TRUE, 
        "test"
       ),
       bs4TableItem(
        actionButton(
         "go",
         "Go"
        )
       )
      )
     )
    ), 
    footer = bs4DashFooter()
  ),
  server = function(input, output) { }
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
