% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_table}
\alias{bs_table}
\title{Create a HTML table configured with Bootstrap classes}
\usage{
bs_table(
  x = list(),
  headers = NULL,
  table_class = "table",
  row_class = "table",
  cell_class = "table",
  responsive = FALSE,
  responsive_breakpoint = NULL,
  thead_class = NULL,
  tbody_class = NULL,
  striped = FALSE,
  hoverable = FALSE,
  bordered = FALSE,
  border_theme = NULL,
  borderless = FALSE
)
}
\arguments{
\item{x}{A list with entries of equal length (use as.list(dataframe) to convert a data frame to a list).}

\item{headers}{A vector of names to use as table headers instead of the list names (or 1, 2, 3, etc. if list is not named).}

\item{table_class}{A string, the class of the table tag.}

\item{row_class}{A string, the class of the tr tag.}

\item{cell_class}{A string, the class of the th/td tag.}

\item{responsive}{TRUE/FALSE, if TRUE, wraps the table in a div with class "table-responsive".}

\item{responsive_breakpoint}{A string, gets appended to class "table-responsive-" in a div wrapping the table.
One of "sm", "md", "lg", "xl", "xxl".}

\item{thead_class}{A string, the class of the thead tag.}

\item{tbody_class}{A string, the class of the tbody tag.}

\item{striped}{TRUE/FALSE, if TRUE, adds "table-striped" to the table class.}

\item{hoverable}{TRUE/FALSE, if TRUE, adds "table-hover" to the table class.}

\item{bordered}{TRUE/FALSE, if TRUE, adds "table-bordered" to the table class.}

\item{border_theme}{A string, one of the Bootstrap color themes (ex. "primary", "secondary", "warning", etc.).}

\item{borderless}{TRUE/FALSE, if TRUE (and bordered is FALSE), adds "table-borderless" to the table class.}
}
\value{
A string of HTML.
}
\description{
Create a HTML table configured with Bootstrap classes
}
\examples{
bs_table(
x = list(
col1 = c(1, 2, 3, 4, 5),
col2 = c("a", "b", "c", "d", "e"),
col3 = c(1, 2, 3, 4, 5),
col4 = c("test", "test", "test", "test", "test")
),
headers = c("First", "Second", "Third", "Fourth"),
table_class = "table table-primary",
row_class = "table table-primary",
cell_class = "table table-primary"
)
}
