% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_textarea}
\alias{bs_textarea}
\title{Create a HTML textarea tag configured with Bootstrap classes}
\usage{
bs_textarea(
  id,
  value = NULL,
  label = NULL,
  placeholder = NULL,
  rows = NULL,
  custom_height = NULL,
  div_class = NULL,
  textarea_class = "form-control",
  label_class = "form-label",
  text = NULL,
  text_class = "form-text",
  textarea_args = list(),
  inline = FALSE
)
}
\arguments{
\item{id}{A string, the id/name for the textarea, passed to the id and name params of html5::textarea().}

\item{value}{A string, the value of the textarea, passed to the value param of html5::textarea().}

\item{label}{A string, the label to use for the textarea, passed to html5::label().}

\item{placeholder}{A string, passed to the placeholder param of html5::textarea().}

\item{rows}{An integer, the number of rows for the textarea, passed to the rows param of html5::textarea().}

\item{custom_height}{A string, should indicate a number and unit (ex. "100px") that gets appended to "height: " and passed to the style param of html5::textarea().}

\item{div_class}{A string, the class of the div tag surrounding the the label and textarea tags.}

\item{textarea_class}{A string, the class of the textarea tag.}

\item{label_class}{A string, the class of the label tag.}

\item{text}{A string, text or HTML to display with the textarea and label tags.}

\item{text_class}{A string, the class of the text or HTML to display with the textarea and label tags.}

\item{textarea_args}{A named list, names should correspond to a parameter of the html5::textarea() function and values will be passed to that parameter.}

\item{inline}{TRUE/FALSE, if TRUE, adds a div and classes to display the label and textarea and text in the same line.}
}
\value{
A string of HTML.
}
\description{
Create a HTML textarea tag configured with Bootstrap classes
}
\examples{
bs_textarea(
id = "example1",
label = "Example Text Area Input"
)
}
