% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-theme.R
\name{bs_theme}
\alias{bs_theme}
\alias{bs_theme_update}
\alias{is_bs_theme}
\title{Create a Bootstrap theme}
\usage{
bs_theme(
  version = version_default(),
  preset = NULL,
  ...,
  bg = NULL,
  fg = NULL,
  primary = NULL,
  secondary = NULL,
  success = NULL,
  info = NULL,
  warning = NULL,
  danger = NULL,
  base_font = NULL,
  code_font = NULL,
  heading_font = NULL,
  font_scale = NULL,
  bootswatch = NULL
)

bs_theme_update(
  theme,
  ...,
  preset = NULL,
  bg = NULL,
  fg = NULL,
  primary = NULL,
  secondary = NULL,
  success = NULL,
  info = NULL,
  warning = NULL,
  danger = NULL,
  base_font = NULL,
  code_font = NULL,
  heading_font = NULL,
  font_scale = NULL,
  bootswatch = NULL
)

is_bs_theme(x)
}
\arguments{
\item{version}{The major version of Bootstrap to use (see \code{\link[=versions]{versions()}}
for possible values). Defaults to the currently recommended version
for new projects (currently Bootstrap 5).}

\item{preset}{The name of a theme preset, either a built-in theme provided by
bslib or a Bootswatch theme (see \code{\link[=builtin_themes]{builtin_themes()}} and
\code{\link[=bootswatch_themes]{bootswatch_themes()}} for possible values). This argument takes precedence
over the \code{bootswatch} argument and only one \code{theme} or \code{bootswatch} can be
provided. When provided to \code{bs_theme_update()}, any previous preset theme
is first removed before the new theme preset is applied. You can use
\code{theme = "bootstrap"} to remove any preset theme and to revert to a base
Bootstrap theme.}

\item{...}{arguments passed along to \code{\link[=bs_add_variables]{bs_add_variables()}}.}

\item{bg}{A color string for the background.}

\item{fg}{A color string for the foreground.}

\item{primary}{A color to be used for hyperlinks, to indicate primary/default
actions, and to show active selection state in some Bootstrap components.
Generally a bold, saturated color that contrasts with the theme's base
colors.}

\item{secondary}{A color for components and messages that don't need to stand
out. (Not supported in Bootstrap 3.)}

\item{success}{A color for messages that indicate an operation has succeeded.
Typically green.}

\item{info}{A color for messages that are informative but not critical.
Typically a shade of blue-green.}

\item{warning}{A color for warning messages. Typically yellow.}

\item{danger}{A color for errors. Typically red.}

\item{base_font}{The default typeface.}

\item{code_font}{The typeface to be used for code. Be sure this is monospace!}

\item{heading_font}{The typeface to be used for heading elements.}

\item{font_scale}{A scalar multiplier to apply to the base font size. For
example, a value of \code{1.5} scales font sizes to 150\% and a value of \code{0.8}
scales to 80\%. Must be a positive number.}

\item{bootswatch}{The name of a bootswatch theme (see \code{\link[=bootswatch_themes]{bootswatch_themes()}}
for possible values). When provided to \code{bs_theme_update()}, any previous
Bootswatch theme is first removed before the new one is applied (use
\code{bootswatch = "bootstrap"} to effectively remove the Bootswatch theme).}

\item{theme}{a \code{\link[=bs_theme]{bs_theme()}} object.}

\item{x}{an object.}
}
\value{
a \code{\link[sass:sass_layer]{sass::sass_bundle()}} (list-like) object.
}
\description{
Creates a Bootstrap theme object, where you can:
\itemize{
\item Choose a (major) Bootstrap \code{version}.
\item Choose a \href{https://bootswatch.com}{Bootswatch theme} (optional).
\item Customize main colors and fonts via explicitly named arguments (e.g.,
\code{bg}, \code{fg}, \code{primary}, etc).
\item Customize other, lower-level, Bootstrap Sass variable defaults via \code{...}.
}

To learn more about how to implement custom themes, as well as how to use them inside Shiny and R Markdown, \href{https://rstudio.github.io/bslib/articles/theming.html}{see here}.
}
\section{Colors}{


Colors may be provided in any format that \code{\link[htmltools:parseCssColors]{htmltools::parseCssColors()}} can
understand. To control the vast majority of the ('grayscale') color
defaults, specify both the \code{fg} (foreground) and \code{bg} (background) colors.
The \code{primary} and \code{secondary} theme colors are also useful for accenting the
main grayscale colors in things like hyperlinks, tabset panels, and buttons.
}

\section{Fonts}{


Use \code{base_font}, \code{code_font}, and \code{heading_font} to control the main
typefaces. These arguments set new defaults for the relevant \code{font-family}
CSS properties, but don't necessarily import the relevant font files. To
both set CSS properties \emph{and} import font files, consider using the various
\code{\link[=font_face]{font_face()}} helpers.

Each \verb{*_font} argument may be collection of character vectors,
\code{\link[=font_google]{font_google()}}s, \code{\link[=font_link]{font_link()}}s and/or \code{\link[=font_face]{font_face()}}s. Note that a
character vector can have:
\itemize{
\item A single unquoted name (e.g., \code{"Source Sans Pro"}).
\item A single quoted name (e.g., \code{"'Source Sans Pro'"}).
\item A comma-separated list of names w/ individual names quoted as necessary.
(e.g. \code{c("Open Sans", "'Source Sans Pro'", "'Helvetica Neue', Helvetica, sans-serif")})
}

Since \code{font_google(..., local = TRUE)} guarantees that the client has access to
the font family, meaning it's relatively safe to specify just one font
family, for instance:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bs_theme(base_font = font_google("Pacifico", local = TRUE))
}\if{html}{\out{</div>}}

However, specifying multiple "fallback" font families is recommended,
especially when relying on remote and/or system fonts being available, for
instance. Fallback fonts are useful not only for handling missing fonts, but
also for handling a Flash of Invisible Text (FOIT) which can be quite
noticeable with remote web fonts on a slow internet connection.

\if{html}{\out{<div class="sourceCode">}}\preformatted{bs_theme(base_font = font_collection(font_google("Pacifico", local = FALSE), "Roboto", "sans-serif"))
}\if{html}{\out{</div>}}
}

\examples{

theme <- bs_theme(
  # Controls the default grayscale palette
  bg = "#202123", fg = "#B8BCC2",
  # Controls the accent (e.g., hyperlink, button, etc) colors
  primary = "#EA80FC", secondary = "#48DAC6",
  base_font = c("Grandstander", "sans-serif"),
  code_font = c("Courier", "monospace"),
  heading_font = "'Helvetica Neue', Helvetica, sans-serif",
  # Can also add lower-level customization
  "input-border-color" = "#EA80FC"
)
if (interactive()) {
  bs_theme_preview(theme)
}

# Lower-level bs_add_*() functions allow you to work more
# directly with the underlying Sass code
theme <- bs_add_variables(theme, "my-class-color" = "red")
theme <- bs_add_rules(theme, ".my-class { color: $my-class-color }")

}
\references{
\url{https://rstudio.github.io/bslib/articles/theming.html}

\url{https://rstudio.github.io/sass/}
}
\seealso{
\code{\link[=bs_add_variables]{bs_add_variables()}}, \code{\link[=bs_theme_preview]{bs_theme_preview()}}
}
