% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lgg_ssm}
\alias{lgg_ssm}
\title{General multivariate linear Gaussian state space models}
\usage{
lgg_ssm(y, Z, H, T, R, a1, P1, theta, obs_intercept, state_intercept,
  known_params = NA, known_tv_params = matrix(NA), n_states, n_etas,
  log_prior_pdf, time_varying = rep(TRUE, 6),
  state_names = paste0("state", 1:n_states))
}
\arguments{
\item{y}{Observations as multivariate time series (or matrix) of length \eqn{n}.}

\item{Z, H, T, R, a1, P1, obs_intercept, state_intercept}{An external pointers for the C++ functions which
define the corresponding model functions.}

\item{theta}{Parameter vector passed to all model functions.}

\item{known_params}{Vector of known parameters passed to all model functions.}

\item{known_tv_params}{Matrix of known parameters passed to all model functions.}

\item{n_states}{Number of states in the model.}

\item{n_etas}{Dimension of the noise term of the transition equation.}

\item{log_prior_pdf}{An external pointer for the C++ function which
computes the log-prior density given theta.}

\item{time_varying}{Optional logical vector of length 6, denoting whether the values of
Z, H, T, R, D and C can vary with respect to time variable.
If used, can speed up some computations.}

\item{state_names}{Names for the states.}
}
\value{
Object of class \code{llg_ssm}.
}
\description{
Constructs an object of class \code{llg_ssm} by defining the corresponding terms
of the observation and state equation:
}
\details{
\deqn{y_t = D(t,\theta) + Z(t,\theta)  \alpha_t + H(t, \theta) \epsilon_t, (\textrm{observation equation})}
\deqn{\alpha_{t+1} = C(t,\theta) + T(t, \theta) \alpha_t + R(t, \theta)\eta_t, (\textrm{transition equation})}

where \eqn{\epsilon_t \sim N(0, I_p)}, \eqn{\eta_t \sim N(0, I_m)} and
\eqn{\alpha_1 \sim N(a_1, P_1)} independently of each other.

Compared to other models, these general models need a bit more effort from
the user, as you must provide the several small C++ snippets which define the
model structure. See examples in the vignette.
}
