% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ekpf_filter.R
\name{ekpf_filter}
\alias{ekpf_filter}
\alias{ekpf_filter.ssm_nlg}
\title{Extended Kalman Particle Filtering}
\usage{
ekpf_filter(object, particles, ...)

\method{ekpf_filter}{ssm_nlg}(
  object,
  particles,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{object}{of class \code{ssm_nlg}.}

\item{particles}{Number of particles.}

\item{...}{Ignored.}

\item{seed}{Seed for RNG.}
}
\value{
A list containing samples, filtered estimates and the corresponding covariances,
weights from the last time point, and an estimate of log-likelihood.
}
\description{
Function \code{ekpf_filter} performs a extended Kalman particle filtering with stratification
resampling, based on Van Der Merwe et al (2001).
}
\references{
Van Der Merwe, R., Doucet, A., De Freitas, N., & Wan, E. A. (2001). The unscented particle filter. In Advances in neural information processing systems (pp. 584-590).
}
