% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ribbon}
\alias{plot_ribbon}
\title{Plots the median and an interval between two specified percentiles 
for a sequence of \code{K} random variables}
\usage{
plot_ribbon(
  draws,
  probability = 0.9,
  col = "#ff69b4",
  ylim,
  ylab,
  xlab,
  start_at = 0,
  add = FALSE,
  ...
)
}
\arguments{
\item{draws}{a \code{K x S} matrix with \code{S} posterior draws of 
\code{K} random variables, or a \code{K x S x N} array with \code{N} such matrices}

\item{probability}{a number from interval \code{(0,1)} denoting the probability 
content of the plotted interval. The interval stretches from the 
\code{0.5 * (1 - probability)} to \code{1 - 0.5 * (1 - probability)} percentile 
of the posterior distribution.}

\item{col}{a colour of the plot}

\item{ylim}{the range of the \code{y} axis}

\item{ylab}{the label of the \code{y} axis}

\item{xlab}{the label of the \code{x} axis}

\item{start_at}{an integer to denote the beginning of the \code{x} axis range}

\item{add}{a logical value. If \code{TRUE} the current ribbon plot is added 
to an existing plot}

\item{...}{other graphical parameters to be passed to \code{base::plot}}
}
\description{
Plots the median and an interval between two specified percentiles 
for a sequence of \code{K} random variables based on the \code{S} posterior 
draws provided for each of them.
}
\examples{
data(us_fiscal_lsuw)                                               # upload data
set.seed(123)                                                      # set seed
specification  = specify_bsvar$new(us_fiscal_lsuw)                 # specify model

burn_in        = estimate(specification, 10)                       # run the burn-in
posterior      = estimate(burn_in, 20, thin = 1)                   # estimate the model
irf            = compute_impulse_responses(posterior, horizon = 4) # impulse responses
plot_ribbon(irf[1,1,,])

}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
