% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify_identification.PosteriorBSVART}
\alias{verify_identification.PosteriorBSVART}
\title{Verifies identification through heteroskedasticity or non-normality of 
of structural shocks}
\usage{
\method{verify_identification}{PosteriorBSVART}(posterior)
}
\arguments{
\item{posterior}{the estimation outcome obtained using \code{\link{estimate}} function}
}
\value{
An object of class \code{SDDRidT} that is a list with components:

\code{logSDDR} the value of the logarithm of the Bayes factor

\code{SDDR} the value of the Bayes factor
}
\description{
Computes the logarithm of Bayes factor for the hypothesis of normality
of the joint conditional distribution of the structural shocks via 
Savage-Dickey Density Ration (SDDR).
The hypothesis of normality in this t-distributed shocks model is represented 
by restriction setting the degrees-of-freedom parameter \eqn{\nu} to infinity:
\deqn{H_0: \nu = \infty}
The logarithm of Bayes factor for this hypothesis can be computed using the SDDR 
as the difference of logarithms of the marginal posterior distribution ordinate at the restriction 
less the marginal prior distribution ordinate at the same point:
\deqn{log p(H_0 | data) - log p(H_0)}
Therefore, a negative value of the difference is the evidence against 
homoskedasticity of the structural shock. The estimation of the marginal posterior
ordinate is done using truncated Gaussian kernel smoothing.
}
\examples{
# simple workflow
############################################################
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_t$new(us_fiscal_lsuw)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_t$new() |>
  estimate(S = 10) |> 
  verify_identification() -> sddr
  
}
\references{
Lütkepohl, H., and Woźniak, T., (2020) Bayesian Inference for Structural Vector Autoregressions Identified by Markov-Switching Heteroskedasticity. \emph{Journal of Economic Dynamics and Control} \bold{113}, 103862, \doi{10.1016/j.jedc.2020.103862}.

Lütkepohl, H., Shang, F., Uzeda, L., and Woźniak, T. (2024) Partial Identification of Heteroskedastic Structural VARs: Theory and Bayesian Inference. \emph{University of Melbourne Working Paper}, 1--57, \doi{10.48550/arXiv.2404.11057}.
}
\seealso{
\code{\link{specify_bsvar_t}}, \code{\link{estimate}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
