% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildmer}
\alias{buildmer}
\title{Use \code{buildmer} to fit mixed-effects models using \code{lmer}/\code{glmer} from \code{lme4}}
\usage{
buildmer(formula, data = NULL, family = gaussian(), cl = NULL,
  direction = c("order", "backward"), crit = "LRT", include = NULL,
  reduce.fixed = TRUE, reduce.random = TRUE, calc.anova = FALSE,
  calc.summary = TRUE, ddf = "Wald", ...)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{reduce.fixed}{See the general documentation under \code{\link{buildmer-package}}}

\item{reduce.random}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.anova}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{ddf}{The method used for calculating \emph{p}-values if \code{calc.anova=FALSE} or \code{calc.summary=TRUE}. Options are \code{'Wald'} (default), \code{'Satterthwaite'} (if package \code{lmerTest} is available), \code{'Kenward-Roger'} (if packages \code{lmerTest} and \code{pbkrtest} are available), and \code{'lme4'} (no \emph{p}-values)}

\item{...}{Additional options to be passed to \code{lmer}, \code{glmer}, or \code{gamm4}. (They will also be passed to \code{(g)lm} in so far as they're applicable, so you can use arguments like \code{subset=...} and expect things to work. The single exception is the \code{control} argument, which is assumed to be meant only for \code{lme4} and not for \code{(g)lm}, and will \emph{not} be passed on to \code{(g)lm}.)}
}
\description{
Use \code{buildmer} to fit mixed-effects models using \code{lmer}/\code{glmer} from \code{lme4}
}
\examples{
library(buildmer)
m <- buildmer(Reaction ~ Days + (Days|Subject),lme4::sleepstudy)

#tests from github issue #2:
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
           family=binomial,data=lme4::cbpp)
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
           family=binomial,data=lme4::cbpp,direction='forward')
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
           family=binomial,data=lme4::cbpp,crit='AIC')
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
           family=binomial,data=lme4::cbpp,direction='forward',crit='AIC')
}
