% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildmertree}
\alias{buildmertree}
\title{Use \code{buildmer} to perform stepwise elimination for \emph{the random-effects part} of \code{lmertree()} and \code{glmertree()} models from package \code{glmertree}}
\usage{
buildmertree(formula, data = NULL, family = gaussian(), cl = NULL,
  direction = c("order", "backward"), crit = "AIC", include = NULL,
  reduce.fixed = TRUE, reduce.random = TRUE, calc.summary = TRUE,
  ...)
}
\arguments{
\item{formula}{Either a \code{glmertree} formula, looking like \code{dep ~ left | middle | right} where the \code{middle} part is an \code{lme4}-style random-effects specification, or an ordinary formula (or buildmer term list thereof) specifying only the dependent variable and the fixed and random effects for the regression part. In the latter case, the additional argument \code{partitioning} must be specified as a one-sided formula containing the partitioning part of the model.}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{reduce.fixed}{See the general documentation under \code{\link{buildmer-package}}}

\item{reduce.random}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{...}{Additional options to be passed to \code{lmertree} or \code{glmertree}. (They will also be passed to \code{(g)lmtree} in so far as they're applicable. The single exception is the \code{control} argument, which is assumed to be meant only for \code{(g)lmertree} and not for \code{(g)lmtree}, and will \emph{not} be passed on to \code{(g)lmtree}.)}
}
\description{
Use \code{buildmer} to perform stepwise elimination for \emph{the random-effects part} of \code{lmertree()} and \code{glmertree()} models from package \code{glmertree}
}
\details{
Note that the likelihood-ratio test is not available for \code{glmertree} models, as it cannot be assured that the models being compared are nested. The default is thus to use AIC.
It is recommended to pass \code{joint=FALSE}, as this speeds up the fits (drastically so in the case of a generalized linear mixed model), and reduces the odds of the final \code{(g)lmer} model failing to converge or converging singularly.
}
\examples{
library(buildmer)
m <- buildmertree(Reaction ~ 1 | (Days|Subject) | Days,crit='LL',direction='order',
                  data=lme4::sleepstudy,joint=FALSE)
m <- buildmertree(Reaction ~ 1 | (Days|Subject) | Days,crit='LL',direction='order',
                  data=lme4::sleepstudy,family=Gamma(link=identity),joint=FALSE)
}
\seealso{
\code{\link{buildmer-package}}
}
