% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildjulia}
\alias{buildjulia}
\title{Use \code{buildmer} to perform stepwise elimination on models fit with Julia package \code{MixedModels} via \code{JuliaCall}}
\usage{
buildjulia(
  formula,
  data = NULL,
  family = gaussian(),
  include = NULL,
  julia_family = gaussian(),
  julia_link = NULL,
  julia_fun = NULL,
  direction = c("order", "backward"),
  crit = "LRT",
  ...
)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{julia_family}{For generalized linear mixed models, the name of the Julia function to evaluate to obtain the error distribution. Only used if \code{family} is non-Gaussian This should probably be the same as \code{family} but with an initial capital, with the notable exception of logistic regression: if the R family is \code{binomial}, the Julia family should be \code{'Bernoulli'}}

\item{julia_link}{For generalized linear mixed models, the name of the Julia function to evaluate to obtain the link function. Only used if \code{family} is non-Gaussian If not provided, Julia's default link for your error distribution is used}

\item{julia_fun}{If you need to change some parameters in the Julia model object before Julia \code{fit!} is called, you can provide an R function to manipulate the unfitted Julia object here. This function should accept two arguments: the first is the \code{julia} structure, which is a list containing a \code{call} element you can use as a function to call Julia; the second argument is the R \code{JuliaObject} corresponding to the unfitted Julia model. This can be used to e.g. change optimizer parameters before the model is fitted}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{...}{Additional options to be passed to \code{LinearMixedModel()} or \code{GeneralizedLinearMixedModel()}}
}
\description{
Use \code{buildmer} to perform stepwise elimination on models fit with Julia package \code{MixedModels} via \code{JuliaCall}
}
\examples{
\donttest{
if (requireNamespace('JuliaCall')) model <- buildjulia(f1 ~ vowel*timepoint*following +
       (1|participant) + (1|word),data=vowels)
}
}
\seealso{
\code{\link{buildmer-package}}
}
