% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternFuns.R
\name{make_pattern_matrix}
\alias{make_pattern_matrix}
\title{Create a matrix of the patterns between conditions}
\usage{
make_pattern_matrix(tbl, n_sd = 2)
}
\arguments{
\item{tbl}{the output of \code{\link{calculate_condition_mean_sd_per_gene}}}

\item{n_sd}{number of standard deviations from the mean to use to
construct the intervals; default is 2}
}
\value{
A matrix of single character patterns between conditions. The last
column is named pattern and is a concatenation of all other columns.
}
\description{
This function determines the patterns between different
conditions of each gene. It should be applied to the output of
\code{\link{calculate_condition_mean_sd_per_gene}}.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

condition <- factor(rep(c("0h", "12h", "36h"), each = 2))
tbl <- calculate_condition_mean_sd_per_gene(expression.matrix.preproc[1:10, ], condition)
patmat <- make_pattern_matrix(tbl)
patmat
}
