% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/act_collapse.R
\name{act_collapse}
\alias{act_collapse}
\alias{act_collapse.eventlog}
\title{Collapse activity labels of a sub process into a single activity}
\usage{
act_collapse(eventlog, ..., method)

\method{act_collapse}{eventlog}(eventlog, ..., method = c("entry_points", "consecutive"))
}
\arguments{
\item{eventlog}{An \code{eventlog} object}

\item{...}{A series of named character vectors. The activity labels in each vector will be collapsed into one activity with the name of the vector.}

\item{method}{Defines how activities are collapsed: "entry_points" heuristically learns which of the specified activities occur at the start and end of the subprocess and collapses accordingly. "consecutive" collapses consecutive sequences of the activities.}
}
\description{
Collapse activity labels of a sub process into a single activity
}
\details{
There are different strategies to collapse activity labels (argument ´method´). The "entry_points" method aims to learn the start and end activities of the sub process, by looking at the first and last activity in each case over the whole log. Subsequently, it will create a new instance of the sub process each time there is an end activity followed by a start activity. This strategy will not take into account other activities happening in the mean time. The "consecutive" method will create an instance each time a new sequence of sub activities is started. This strategy will thus only take into account interruptions of the other activity labels.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Collapse activity labels of a subprocess into a single activity
}}

\seealso{
Other Activity processing functions: 
\code{\link{act_recode}()},
\code{\link{act_unite}()}
}
\concept{Activity processing functions}
