% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_mniw}
\alias{sim_mniw}
\title{Generate Normal-IW Random Family}
\usage{
sim_mniw(num_sim, mat_mean, mat_scale_u, mat_scale, shape)
}
\arguments{
\item{num_sim}{Number to generate}

\item{mat_mean}{Mean matrix of MN}

\item{mat_scale_u}{First scale matrix of MN}

\item{mat_scale}{Scale matrix of IW}

\item{shape}{Shape of IW}
}
\value{
List of MN and IW matrices.
Multiple samples are column-stacked.
}
\description{
This function samples normal inverse-wishart matrices.
}
\details{
Consider \eqn{(Y_i, \Sigma_i) \sim MIW(M, U, \Psi, \nu)}.
\enumerate{
\item Generate upper triangular factor of \eqn{\Sigma_i = C_i C_i^T} in the upper triangular Bartlett decomposition.
\item Standard normal generation: n x k matrix \eqn{Z_i = [z_{ij} \sim N(0, 1)]} in row-wise direction.
\item Lower triangular Cholesky decomposition: \eqn{U = P P^T}
\item \eqn{A_i = M + P Z_i C_i^T}
}
}
