% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-varlse.R, R/print-varlse.R
\name{summary.varlse}
\alias{summary.varlse}
\alias{print.summary.varlse}
\alias{knit_print.summary.varlse}
\title{Summarizing Vector Autoregressive Model}
\usage{
\method{summary}{varlse}(object, ...)

\method{print}{summary.varlse}(x, digits = max(3L, getOption("digits") - 3L), signif_code = TRUE, ...)

knit_print.summary.varlse(x, ...)
}
\arguments{
\item{object}{\code{varlse} object}

\item{...}{not used}

\item{x}{\code{summary.varlse} object}

\item{digits}{digit option to print}

\item{signif_code}{Check significant rows (Default: \code{TRUE})}
}
\value{
\code{summary.varlse} \link{class} additionally computes the following
\item{\code{names}}{Variable names}
\item{\code{totobs}}{Total number of the observation}
\item{\code{obs}}{Sample size used when training = \code{totobs} - \code{p}}
\item{\code{p}}{Lag of VAR}
\item{\code{coefficients}}{Coefficient Matrix}
\item{\code{call}}{Matched call}
\item{\code{process}}{Process: VAR}
\item{\code{covmat}}{Covariance matrix of the residuals}
\item{\code{corrmat}}{Correlation matrix of the residuals}
\item{\code{roots}}{Roots of characteristic polynomials}
\item{\code{is_stable}}{Whether the process is stable or not based on \code{roots}}
\item{\code{log_lik}}{log-likelihood}
\item{\code{ic}}{Information criteria vector}
\itemize{
\item{\code{AIC}} - AIC
\item{\code{BIC}} - BIC
\item{\code{HQ}} - HQ
\item{\code{FPE}} - FPE
}
}
\description{
\code{summary} method for \code{varlse} class.
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
