% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-bayes.R, R/print-summarymniw.R
\name{summary.normaliw}
\alias{summary.normaliw}
\alias{print.summary.normaliw}
\alias{knit_print.summary.normaliw}
\title{Summarizing Bayesian Multivariate Time Series Model}
\usage{
\method{summary}{normaliw}(
  object,
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  verbose = FALSE,
  num_thread = 1,
  ...
)

\method{print}{summary.normaliw}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{summary.normaliw}(x, ...)
}
\arguments{
\item{object}{A \code{normaliw} object}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{Number of threads}

\item{...}{not used}

\item{x}{\code{summary.normaliw} object}

\item{digits}{digit option to print}
}
\value{
\code{summary.normaliw} \link{class} has the following components:
\describe{
\item{names}{Variable names}
\item{totobs}{Total number of the observation}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{call}{Matched call}
\item{spec}{Model specification (\code{bvharspec})}
\item{mn_mean}{MN Mean of posterior distribution (MN-IW)}
\item{mn_prec}{MN Precision of posterior distribution (MN-IW)}
\item{iw_scale}{IW scale of posterior distribution (MN-IW)}
\item{iw_shape}{IW df of posterior distribution (MN-IW)}
\item{iter}{Number of MCMC iterations}
\item{burn}{Number of MCMC burn-in}
\item{thin}{MCMC thinning}
\item{alpha_record (BVAR) and phi_record (BVHAR)}{MCMC record of coefficients vector}
\item{psi_record}{MCMC record of upper cholesky factor}
\item{omega_record}{MCMC record of diagonal of cholesky factor}
\item{eta_record}{MCMC record of upper part of cholesky factor}
\item{param}{MCMC record of every parameter}
\item{coefficients}{Posterior mean of coefficients}
\item{covmat}{Posterior mean of covariance}
}
}
\description{
\code{summary} method for \code{normaliw} class.
}
\details{
From Minnesota prior, set of coefficient matrices and residual covariance matrix have matrix Normal Inverse-Wishart distribution.

BVAR:

\deqn{(A, \Sigma_e) \sim MNIW(\hat{A}, \hat{V}^{-1}, \hat\Sigma_e, \alpha_0 + n)}
where \eqn{\hat{V} = X_\ast^T X_\ast} is the posterior precision of MN.

BVHAR:

\deqn{(\Phi, \Sigma_e) \sim MNIW(\hat\Phi, \hat{V}_H^{-1}, \hat\Sigma_e, \nu + n)}
where \eqn{\hat{V}_H = X_{+}^T X_{+}} is the posterior precision of MN.
}
\references{
Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.

Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).
}
