% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{tooltip}
\alias{tooltip}
\alias{tooltip.c3}
\title{C3 Tooltips}
\usage{
tooltip(c3, show = TRUE, grouped = TRUE, format = NULL, position = NULL,
  contents = NULL, ...)

\method{tooltip}{c3}(c3, show = TRUE, grouped = TRUE, format = NULL,
  position = NULL, contents = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{show}{boolean show or hide tooltips}

\item{grouped}{boolean}

\item{format}{list with options:
\itemize{
 \item{title}{: character js function, wrap character or character vector in JS()}
 \item{name}{: character js function, wrap character or character vector in JS()}
 \item{value}{: character js function, wrap character or character vector in JS()}
}}

\item{position}{character js function, wrap character or character vector in JS()}

\item{contents}{character js function, wrap character or character vector in JS()}

\item{...}{addition options passed to the tooltip object}
}
\value{
c3
}
\description{
Modify plot elements that relate to tooltips. C3.js documentation contains an \href{http://c3js.org/samples/tooltip_format.html}{extended example}.
}
\examples{
data <- data.frame(a = abs(rnorm(20) *10),
                   b = abs(rnorm(20) *10),
                   c = abs(rnorm(20) *10),
                   d = abs(rnorm(20) *10))
data \%>\%
  c3() \%>\%
  tooltip(format = list(title = htmlwidgets::JS("function (x) { return 'Data ' + x; }"),
                        name = htmlwidgets::JS('function (name, ratio, id, index)',
                                               ' { return name; }'),
                        value = htmlwidgets::JS('function (value, ratio, id, index)',
                                                ' { return ratio; }')))

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{grid}}, \code{\link{legend}},
  \code{\link{region}}, \code{\link{subchart}},
  \code{\link{xAxis}}, \code{\link{zoom}}
}
