% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{BergamiBagozzi2000}
\alias{BergamiBagozzi2000}
\title{Data: BergamiBagozzi2000}
\format{An object of class \code{data.frame} with 305 rows and 22 columns.}
\source{
Survey among South Korean employees conducted and
reported by \insertCite{Bergami2000;textual}{cSEM}.
}
\usage{
BergamiBagozzi2000
}
\description{
A data frame containing 22 variables with 305 observations.
}
\details{
The dataset contains 22 variables and originates
from a larger survey among South Korean employees conducted and
reported by \insertCite{Bergami2000;textual}{cSEM}. It is
also used in  \insertCite{Hwang2014;textual}{cSEM} and
\insertCite{Henseler2020;textual}{cSEM}
for demonstration purposes (Tutorial 6).
}
\examples{
#============================================================================
# Example is taken from Henseler (2020)
#============================================================================
model_Bergami_Bagozzi="
# Measurement models
OrgPres =~ cei1 + cei2 + cei3 + cei4 + cei5 + cei6 + cei7 + cei8 
OrgIden =~ ma1 + ma2 + ma3 + ma4 + ma5 + ma6
AffLove =~ orgcmt1 + orgcmt2 + orgcmt3 + orgcmt7
AffJoy  =~ orgcmt5 + orgcmt8
Gender  <~ gender

# Structural model 
OrgIden ~ OrgPres
AffLove ~ OrgPres + OrgIden + Gender 
AffJoy  ~ OrgPres + OrgIden + Gender 
"

out <- csem(.data = BergamiBagozzi2000, .model = model_Bergami_Bagozzi,
            .PLS_weight_scheme_inner = 'factorial',
            .tolerance = 1e-06
)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
