% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_population.R
\name{plot_population}
\alias{plot_population}
\title{Plotting of a population of objectives}
\usage{
plot_population(MatObj, nobj, ngen = NULL, nrun = NULL, objnames = NULL,
  MatEvol = NULL, popsize = 0)
}
\arguments{
\item{MatObj}{: matrix of the objectives [NInd, nobj]}

\item{nobj}{: number of objectives}

\item{ngen}{: number of generations (optional)}

\item{nrun}{: number of model evaluations (optional)}

\item{objnames}{: vector of objectives names (optional)}

\item{MatEvol}{: matrix of the evolution of the optimal objectives (optional)}

\item{popsize}{: integer, size of the initial population (optional)}
}
\description{
Plot graphs the population regarding each couple of objectives
}
\examples{
# Definition of the population
Pop <- matrix(runif(300), 100, 3)
# Call the function
plot_population(MatObj = Pop, nobj=3, objnames=c("Obj1","Obj2","Obj3"))

}
\author{
C. Monteil
}
