% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calACSstrStrict.R
\name{calACSstrStrict}
\alias{calACSstrStrict}
\title{Internal function:
Calculate the total number of all common subsequences between 2 strings
Subsequences cannot be interrupted by any item, i.e. q-w is not a common subsequence of q-w-e-r and q-e-w-r due to the interrupting 'e' in the second sequence}
\usage{
calACSstrStrict(strA, strB, sep = "-", dropFirstItem = FALSE,
  ignoreLenOneSubseq = FALSE, ignoreLenZeroSubseq = FALSE)
}
\arguments{
\item{strA}{First string}

\item{strB}{Second string}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}

\item{ignoreLenOneSubseq}{Boolean. If true, all length one subequences are not counted as common subsequences}

\item{ignoreLenZeroSubseq}{Boolean. If true, the length zero subsequence (empty set) is not counted as a common subsequence}
}
\value{
The total number of all common subsequences as an integer
}
\description{
Internal function:
Calculate the total number of all common subsequences between 2 strings
Subsequences cannot be interrupted by any item, i.e. q-w is not a common subsequence of q-w-e-r and q-e-w-r due to the interrupting 'e' in the second sequence
}

