% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%matrix\%}
\alias{\%matrix\%}
\title{Numerical and Symbolic Matrix Product}
\usage{
x \%matrix\% y
}
\arguments{
\item{x}{character or numeric matrix.}

\item{y}{character or numeric matrix.}
}
\value{
character or numeric matrix.
}
\description{
Multiplies two character or numeric matrices, if they are conformable. If one argument is a vector, it will be promoted to either a row or column matrix to make the two arguments conformable. If both are vectors of the same length, it will return the inner product (as a matrix).
}
\examples{
# numeric inner product 
x <- 1:4
x \%matrix\% x  

# symbolic inner product 
x <- letters[1:4]
x \%matrix\% x

# matrix products
x <- letters[1:4]
y <- diag(4)
z <- array(1:12, dim = c(4,3))
y \%matrix\% z
y \%matrix\% x
x \%matrix\% z

}
