% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calibraR-main.R
\name{calibrate}
\alias{calibrate}
\title{Sequential parameter estimation for the calibration of models}
\usage{
calibrate(par, fn, gr = NULL, ..., method = "default", lower = NULL,
  upper = NULL, control = list(), hessian = FALSE, phases = NULL,
  replicates = 1)
}
\arguments{
\item{par}{A numeric vector. The length of the par argument defines the
number of parameters to be estimated (i.e. the dimension of the problem).}

\item{fn}{The function to be minimized.}

\item{gr}{the gradient of \code{fn}. Ignored, added for portability with
other optimization functions.}

\item{method}{The optimization method to be used. The 'default' method
is the AHR-ES (Oliveros & Shin, 2016). All the methods from stats::optim,
optimx::optimx and cmaes::cma_es are available.}

\item{lower}{Lower threshold value(s) for parameters. One value or a vector
of the same length as par. If one value is provided, it is used for all
parameters. \code{NA} means \code{-Inf}. By default \code{-Inf} is used (unconstrained).}

\item{upper}{Upper threshold value(s) for parameters. One value or a vector
of the same length as par. If one value is provided, it is used for all
parameters. \code{NA} means \code{Inf}. By default \code{Inf} is used (unconstrained).}

\item{control}{Parameter for the control of the algorithm itself, see details.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Currently not implemented.}

\item{phases}{An optional vector of the same length as \code{par},
indicating the phase at which each parameter becomes active. If omitted,
default value is 1 for all parameters, performing a single optimization.}

\item{replicates}{The number of replicates for the evaluation of \code{fn}.
The default value is 1. A value greater than 1 is only useful for stochastic
functions.}

\item{\dots}{Additional parameters to be passed to \code{fn}.}
}
\description{
This function performs the optimization of a function, possibly
in sequential phases of increasing complexity, and it is designed for the
calibration of a model, by minimizing the error function \code{fn} associated to it.
}
\details{
In the control list, \code{aggFn} is a function to aggregate \code{fn} to
a scalar value if the returned value is a vector. Some optimization algorithm can
exploite the additional information provided by a vectorial output from \code{fn}.
}
\examples{
calibrate(par=rep(NA, 5), fn=SphereN)
\dontrun{
calibrate(par=rep(NA, 5), fn=SphereN, replicates=3)
calibrate(par=rep(0.5, 5), fn=SphereN, replicates=3, lower=-5, upper=5)
calibrate(par=rep(0.5, 5), fn=SphereN, replicates=3, lower=-5, upper=5, phases=c(1,1,1,2,3))
calibrate(par=rep(0.5, 5), fn=SphereN, replicates=c(1,1,4), lower=-5, upper=5, phases=c(1,1,1,2,3))
}
}
\author{
Ricardo Oliveros-Ramos
}

