% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_perc_risk_index.R
\name{get_perc_risk_index}
\alias{get_perc_risk_index}
\title{get_perc_risk_index}
\usage{
get_perc_risk_index(b, poly, perc_val = 75, mod = "gt")
}
\arguments{
\item{b}{RasterLayer/Brick/Stack containing the historical observations or a
proxy (typically a reanalysis).}

\item{poly}{is the spatial polygon on which to aggregate the values}

\item{perc_val}{is the percentile value used as a threshold}

\item{mod}{defines if the values considered for the mean are above (gt) or
below (lt) the threshold}
}
\value{
The function returns a numeric value (for each layer in \code{b}),
corresponding to the mean of the values of \code{b} above/below a given
percentile of the historical observations.
}
\description{
Generates the mean of the values over a certain percentile
threshold for the portion of the Raster* that intersects a polygon
}
\examples{
\dontrun{
  # Read RISICO test data
  r_risico <- readRDS(system.file("extdata", "RISICO_raster.rds",
                                  package = "caliver"))
  # Set missing crs
  raster::crs(r_risico) <- "+proj=longlat +datum=WGS84 +no_defs"
  
  # Read dummy polygon
  shape <- as(raster::extent(6, 18, 35, 47), "SpatialPolygons")
  # Set missing crs
  raster::crs(shape) <- "+proj=longlat +datum=WGS84 +no_defs"
  
  get_perc_risk_index(b = r_risico, poly = shape, perc_val = 75, mod = "gt")
  
}

}
