% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback.R
\name{callback}
\alias{callback}
\title{Data formatting}
\usage{
callback(data, cluster, candid, callback, comp = "ref")
}
\arguments{
\item{data}{A data frame.}

\item{cluster}{A variable name, identifying the test (e.g. a job offer number).}

\item{candid}{A list of factor names defining the candidates (e.g., gender, origin).}

\item{callback}{A Boolean variable, equal to TRUE for non negative callbacks.}

\item{comp}{An option, equal to "all" or "ref" (the default). "ref" give the comparisons with the reference candidate, and "all" the pairwise comparisons.}
}
\value{
A 'callback' object containing the formatted data sets (\code{fds}), the list of the paired formatted data sets (\code{pfds}), the list of the clusters retained in the paired formatted data sets (\code{cfds}), the names of the candidate variables (\code{candid}) and the name of the callback variable (\code{callback}).
\code{fds} contains the following variables:
\tabular{ll}{
\code{cluster} \tab the cluster variable.\cr
\code{candid}\tab the concatenation of the candidate variables.\cr
\code{callback}\tab the callback variables.\cr
}
\code{pfds} data frames containing the following variables:
\tabular{ll}{
\code{callback1}\tab TRUE if candidate 1 had a callback.\cr
\code{callback2}\tab TRUE if candidate 2 had a callback.\cr
\code{c00}\tab TRUE if neither candidate was called back.\cr
\code{c10}\tab TRUE if candidate 1 was the only one called back.\cr
\code{c01}\tab TRUE if candidate 2 was the only one called back.\cr
\code{c11}\tab TRUE if both candidates were called back.\cr
\code{callback}\tab TRUE if either candidate was called back.\cr
\code{calldif}\tab callback difference (\code{callback1-callback2}).\cr
}
\code{cfds} data frames containing the \code{cluster} variable.
}
\description{
Creates the data set used in the callback package.
}
\examples{
data(inter1)
callback(data=inter1,cluster="offer",candid=c("gender","origin"), callback="callback",comp = "ref")
}
