% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_count}
\alias{stat_count}
\title{Callback counts on paired data}
\usage{
stat_count(x)
}
\arguments{
\item{x}{A \code{callback} object.}
}
\value{
A list with class \code{"stat_count"} containing two data frames: counts and
props.

\code{counts:} a data frame with the callback counts.
\itemize{
\item \bold{tests:} number of tests.
\item \bold{callback:} number of tests with at least one callback for either
candidate.
\item \bold{callback1:} number of callbacks for candidate 1.
\item \bold{callback2:} number of callbacks for candidate 2.
\item \bold{c00:} number of test without a callback.
\item \bold{c10:} number of tests with callbacks for candidate 1 only.
\item \bold{c01:} number of tests with callbacks for candidate 2 only.
\item \bold{c11:} number of tests with callbacks for both candidates
\item \bold{calldif:} difference in callback numbers.
 }

\code{props:} a data frame with the following variables.
\itemize{
\item \bold{p_callback:} callback/tests.
\item \bold{p_cand1:} callback1/tests.
\item \bold{p_cand2:} callback2/tests.
\item \bold{p_c00:} c00/tests.
\item \bold{p_c10:} c10/tests.
\item \bold{p_c01:} c01/tests.
\item \bold{p_c11:} c11/tests.
\item \bold{p_cand_dif:} calldif/tests.
}
}
\description{
Computes the callback count statistics from the paired data sets.
}
\examples{
data(labour2)
x <- callback(data=labour2,cluster="offer",candid="hist",callback="callback")
stat_count(x)

}
\author{
Emmanuel Duguet
}
