% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_glob}
\alias{stat_glob}
\title{Unmatched callback rates}
\usage{
stat_glob(x, level = 0.95)
}
\arguments{
\item{x}{A \code{callback} object.}

\item{level}{A number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A \code{stat_glob} object with 5 components : \code{level}, \code{props},
\code{cp}, \code{wilson} and \code{student}.

\code{level}: the level of the confidence intervals

\code{props}: a data frame containing the following variables.
\itemize{
\item\bold{tests:} number of tests.
\item\bold{callback:} number of callbacks.
\item\bold{p_callback:} callback rate.
}

\code{cp}, \code{wilson} and \code{student} are data frames containing the
following variables:
\itemize{
\item\bold{inf_p_callback:} callback rate lower bound.
\item\bold{sup_p_callback:} callback rate upper bound.
}
}
\description{
Number and proportion of callbacks for all the candidates.
}
\examples{
data(labour2)
x <- callback(data=labour2,cluster="offer",candid="hist",callback="callback")
str(stat_glob(x))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
