% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardware_settings.R
\name{Hardware}
\alias{Hardware}
\title{Create hardware settings.}
\usage{
Hardware(
  cpu = 1,
  replicate_parallel = FALSE,
  scenario_parallel = FALSE,
  slice_parallel = FALSE,
  slice_size = NULL,
  dataset_parallel = FALSE,
  dataset_slice_size = 500,
  auto_setup_plan = NULL
)
}
\arguments{
\item{cpu}{number of CPU cores to use, default is 1}

\item{replicate_parallel}{enable parallel computing for replicates, default is FALSE}

\item{scenario_parallel}{enable parallel computing for scenarios, default is FALSE}

\item{slice_parallel}{enable parallel computing for slices, default is FALSE}

\item{slice_size}{number of subjects per simulated slice, default is NULL (auto-configured by Campsis depending on the specified engine)}

\item{dataset_parallel}{enable parallelisation when exporting dataset into a table, default is FALSE}

\item{dataset_slice_size}{dataset slice size when exporting subjects to a table, default is 500. Only applicable if 'dataset_parallel' is enabled.}

\item{auto_setup_plan}{auto-setup plan with the library future, if not set (i.e. =NULL), plan will be setup automatically if the number of CPU's > 1.}
}
\value{
hardware settings
}
\description{
Create hardware settings.
}
