% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communityModel.R
\docType{class}
\name{commOccu-class}
\alias{commOccu-class}
\title{commOccu objects}
\value{
\code{commOccu} object
}
\description{
commOccu objects
}
\section{Slots}{

\describe{
\item{\code{modelText}}{JAGS model code as a character vector (made up of code chunks, use cat() to print)}

\item{\code{params}}{Parameters to monitor in the model runs}

\item{\code{inits_fun}}{Function to create start values for the MCMC chains. It being a function ensures different values in each chain}

\item{\code{data}}{List with data needed to run the model (detection & effort matrices, site covariates, number of species / stations / occasions)}

\item{\code{input}}{Input data_list (unchanged)}

\item{\code{nimble}}{logical indicator for whether it is a Nimble model}

\item{\code{modelFile}}{Path of the text file containing the model code}

\item{\code{covariate_info}}{Data frame containing information about covariates. Only used internally in plot_* and predict methods}
}}

\note{
The \code{data} slot is a list of model input data. While the exact content depends on function input, it can be summarized as:

\tabular{ll}{
\code{y} \tab array of detection histories. Dimensions are: y[species, station, occasion] \cr
\code{effort_binary} \tab matrix of binary (1/0) survey effort. Only used to ensure p = 0 when effort = 0. Dimensions are: effort_binary[station, occasion] \cr
\code{site-occasion covariates} \tab The required content of data_list$obsCovs as named matrices with dimensions [station, occasion] \cr
\code{site covariates} \tab The required columns of data_list$siteCovs as named vectors (length = number of stations) \cr
\code{M} \tab Number of species \cr
\code{J} \tab Number of stations \cr
\code{maxocc} \tab Number of occasions \cr
}

For categorical site-occasion covariates, an addition matrix containing an integer representation of the character matrix with suffix "_integer" is stored in the data slot.
}
