% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaccination.R
\name{get_vaccination_data}
\alias{get_vaccination_data}
\title{Get vaccination data}
\usage{
get_vaccination_data(
  type = c("summary", "reports"),
  split = c("overall", "province", "region"),
  province = NULL,
  region = NULL,
  fill_dates = NULL,
  stat = NULL,
  date = NULL,
  after = NULL,
  before = NULL
)
}
\arguments{
\item{type}{One of "summary" (most recent data) or "reports" (day-to-day
data).}

\item{split}{One of "overall", "province", or "region" to specify how the
data is split. An "overall" summary or report gives cumulative numbers
across Canada. Splitting by "province" returns data for all
provinces/territories. Splitting by "region" is only available for
"summary" data, and returns data for all health regions.}

\item{province}{One or more province/territory codes ("AB", "BC", "MB", "NB",
"NL", "NS", "NT", "NU", "ON", "PE", "QC", "SK", "YT") to get reports.
Upper, lower and mixed case strings are accepted.}

\item{region}{One or more health region IDs to get reports. Numeric and
character values are accepted.}

\item{fill_dates}{When TRUE, the response fills in any missing dates with
blank entries.}

\item{stat}{Returns only the specified statistics, e.g. "cases".}

\item{date}{Returns reports from only the specified date,
in YYYY-MM-DD format.}

\item{after}{Returns reports from only on or after the specified date,
in YYYY-MM-DD format.}

\item{before}{Returns reports from only on or before the specified date,
in YYYY-MM-DD format.}
}
\value{
A data frame containing the vaccinations data. Includes
a \code{province} variable if data is split by province, and a \code{hr_uid} variable
if data is split by health region.
}
\description{
Runs a GET request of vaccination data from the COVID-19 tracker API, and
returns parsed data.
Data may be returned as \code{type} = "summary" (the most recent data) or
\code{type} = "reports" (day-to-day reports).
Via the \code{split} argument, data may be "overall" (all provinces/territories
combined), by "province", or by "region".
Alternatively, provide one or more two-letter codes (e.g. "AB") to \code{province}
to return reports for specific provinces, or one or more numeric \code{region}
codes (e.g. "1204") to return specific health regions.
}
\examples{

get_vaccination_data()
get_vaccination_data(split = "province")
get_vaccination_data(type = "reports", split = "overall")
get_vaccination_data(type = "reports", split = "overall",
                     date = "2021-12-25")
}
